﻿-- 0 - ValidationId

DECLARE @message NVARCHAR(MAX)
SEt @message= 'EDF Trading Watchdog SQL Server SSIS Validation Utility' + CHAR(13) + 'Copyright(C) EDF Trading 2016. All rights reserved.' + CHAR(13)
SELECT @message = @message +  message_desc + ' - ' + message + CHAR(13) from SSISDB.catalog.operation_messages m
INNER JOIN
    (
        VALUES
            (-1,'Unknown')
        ,   (120,'Error')
        ,   (110,'Warning')
        ,   (70,'Information')
        ,   (10,'Pre-validate')
        ,   (20,'Post-validate')
        ,   (30,'Pre-execute')
        ,   (40,'Post-execute')
        ,   (60,'Progress')
        ,   (50,'StatusChange')
        ,   (100,'QueryCancel')
        ,   (130,'TaskFailed')
        ,   (90,'Diagnostic')
        ,   (200,'Custom')
        ,   (140,'DiagnosticEx')
        ,   (400,'NonDiagnostic')
        ,   (80,'VariableValueChanged')
    ) D (message_type, message_desc)
    ON D.message_type = m.message_type
where operation_id = {0}

-- get validation results
select CASE status 
-- The status of the operation. The possible values are created (1), running (2), canceled (3), failed (4), pending (5), ended unexpectedly (6), succeeded (7), stopping (8), and completed (9).
-- DTEXEC status code  Succeeded(0),Failed(1),Canceled(3) Unable to locate(4), Unable to load (5), Utility internal error (6)
WHEN 1 THEN 6 -- created is Utility internal error ( as we will only query after validation is finished)
WHEN 2 THEN 6 -- running is Utility internal error ( as we will only query after validation is finished)
WHEN 3 THEN 3 -- cancelled is cancelled ( as we will only query after validation is finished)
WHEN 4 THEN 1 -- failed is failed 
WHEN 5 THEN 6 -- Pending is Utility internal error ( as we will only query after validation is finished)
WHEN 6 THEN 6 -- ended  is Utility internal error ( as we will only query after validation is finished)
WHEN 7 THEn 0 -- succeeded is succeeded
WHEN 8 THEN 1 -- Completed is failed ( as we will only query after validation is finished)
END as Status,
@message as Message from SSISDB.catalog.validations 
where validation_id = {0}
