﻿using System;
using System.Net;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Documents;
using System.Windows.Ink;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Animation;
using System.Windows.Shapes;
using Microsoft.Practices.Composite.Modularity;
using Microsoft.Practices.Composite.UnityExtensions;
using Telerik.Windows.Controls;
using Microsoft.Practices.Composite.Presentation.Regions;

namespace RadDockingAndPRISM
{
	public class Bootstrapper : UnityBootstrapper
	{
		protected override RegionAdapterMappings ConfigureRegionAdapterMappings()
		{
			var mappings = base.ConfigureRegionAdapterMappings();

		    mappings.RegisterMapping(typeof(RadPaneGroup), this.Container.Resolve<RadPaneGroupRegionAdapter>());

            return mappings;
		}

		protected override DependencyObject CreateShell()
		{
            Shell shell = Container.Resolve<Shell>();
#if SILVERLIGHT
            App.Current.RootVisual = shell;
#else
            shell.Show();
#endif

            return shell;
		}

		protected override IModuleCatalog GetModuleCatalog()
		{
			var catalog = new ModuleCatalog();
			catalog.AddModule(typeof(ModuleA.ModuleA));
            catalog.AddModule(typeof(ModuleB.ModuleB));
			return catalog;
		}
	}
}
