﻿-- Script to create provision a server for validation
-- 0 - JobId
-- 1 - Unc package path
-- 2 - Unc Package config
BEGIN TRANSACTION

DECLARE @jobName					NVARCHAR(max) 
DECLARE @command					NVARCHAR(max) 
DECLARE @PostProcessJobName			NVARCHAR(max)
DECLARE @jobStepValidationCommand	NVARCHAR(MAX)
DECLARE @jobStepFinishCommand		NVARCHAR(MAX)
DECLARE @categoryName				NVARCHAR(MAX)
DECLARE @StepPrefix					SYSNAME
DECLARE @step_name					SYSNAME	

DECLARE @ValidationId BINARY(16)
DECLARE @PostProcessValidationId BINARY(16)
DECLARE @ReturnCode INT
DECLARE @lastJobstepId INT


SET @categoryName		= 'Data Collector'
SET @jobName			= 'Watchdog_Ssis_Validation_{0}'
SET @PostProcessJobName = 'Watchdog_Ssis_Validation_{0}_Cleanup'
SET @jobStepValidationCommand =  N'/FILE "\"{1}\"" /Conf "\"{2}\"" /x86 /CHECKPOINTING OFF /SET "\"\Package.Variables[JobId].Value\"";"\"{0}\"" /REPORTING V'
SET @jobStepFinishCommand  =  N'/FILE "\"{1}\"" /Conf "\"{2}\"" /x86 /CHECKPOINTING OFF /SET "\"\Package.Variables[JobId].Value\"";"\"{0}\"" /SET "\"\Package.Variables[IsFinished].Value\"";"True" /REPORTING V'
SET @StepPrefix =   'Validate_SSIS_Under_'

SELECT @ReturnCode = 0

-- Delete job if it already exists
BEGIN 
	DECLARE @oldValidationId  Uniqueidentifier
			select @oldValidationId = [job_id]
from [msdb].[dbo].[sysjobs] 
where [name] = @jobName

	IF (@oldValidationId IS NOT NULL)
	BEGIN
		print 'Deleting job ' + @jobName
		EXEC msdb.dbo.sp_delete_job @job_id=@oldValidationId, @delete_unused_schedule=1
	END
END

BEGIN 
	-- Create JobCategory [Data Collector] if Not exists
	
	IF NOT EXISTS (SELECT name FROM msdb.dbo.syscategories WHERE name=@categoryName AND category_class=1)
	BEGIN
		EXEC @ReturnCode = msdb.dbo.sp_add_category @class=N'JOB', @type=N'LOCAL', @name=@categoryName
		IF (@@ERROR <> 0 OR @ReturnCode <> 0) 
			BEGIN
				print 'Job Category not found : '+ @categoryName +' for job ' + @jobName
				GOTO QuitWithRollback
			END
	END
END	

-- Create Main validation Job
EXEC @ReturnCode =  msdb.dbo.sp_add_job @job_name=@jobName, 
		@enabled=1, 
		@notify_level_eventlog=0, 
		@notify_level_email=0, 
		@notify_level_netsend=0, 
		@notify_level_page=0, 
		@delete_level=0, 
		@description=N'Watchdog ssis validation job to validate packages used in jobs of this server. If you have created new proxy account then you must reprovision this server using script from watchdog.ProvisionWatchdog_Jobs', 
		@category_name=N'Data Collector', 
		@owner_login_name=N'sa', @job_id = @ValidationId OUTPUT
IF (@@ERROR <> 0 OR @ReturnCode <> 0) GOTO QuitWithRollback

-- Add Validation step undewr sql agent
SET @step_name = @StepPrefix + 'SqlAgent'
EXEC @ReturnCode = msdb.dbo.sp_add_jobstep @job_id=@ValidationId, @step_name=@step_name, 
		@step_id=1, 
		@cmdexec_success_code=0, 
		@on_success_action=3, 
		@on_success_step_id=0, 
		@on_fail_action=3, 
		@on_fail_step_id=0, 
		@retry_attempts=0, 
		@retry_interval=0, 
		@os_run_priority=0, @subsystem=N'SSIS', 
		@command=@jobStepValidationCommand, 
		@database_name=N'master', 
		@flags=0

-- Add validation steps for each proxy accounts
DECLARE @proxyCursor as CURSOR;
DECLARE @proxyname as sysname
DECLARE @proxyAccount as sysname
DECLARE @step_no INT

SET @step_no = 1;
SET @proxyCursor = CURSOR FOR
SELECT 
    name,UPPER(SUSER_SNAME(user_sid)) as account
FROM (
    SELECT *, ROW_NUMBER() OVER (PARTITION BY user_sid ORDER BY user_sid) As rn
    FROM [msdb].[dbo].sysproxies) t
WHERE rn = 1
 
OPEN @proxyCursor;

FETCH NEXT FROM @proxyCursor INTO  @proxyname,@proxyAccount;

WHILE @@FETCH_STATUS = 0
BEGIN
 SET @step_name = @StepPrefix + @proxyAccount;
 SET @step_no = @step_no + 1;
 EXEC @ReturnCode = msdb.dbo.sp_add_jobstep @job_id=@ValidationId, @step_name=@step_name, 
		@step_id=@step_no, 
		@cmdexec_success_code=0, 
		@on_success_action=3, 
		@on_success_step_id=0, 
		@on_fail_action=3, 
		@on_fail_step_id=0, 
		@retry_attempts=0, 
		@retry_interval=0, 
		@os_run_priority=0, @subsystem=N'SSIS', 
		@command=@jobStepValidationCommand, 
		@database_name=N'master', 
		@flags=0, 
		@proxy_name=@proxyname
 FETCH NEXT FROM @proxyCursor INTO  @proxyname,@proxyAccount;
END

SET @step_no = @step_no + 1;

-- Add Step to call job finish (post validation process)
SET @command= N'EXEC msdb.dbo.sp_start_job N''' + @PostProcessJobName + ''';'
EXEC @ReturnCode = msdb.dbo.sp_add_jobstep @job_id=@ValidationId, @step_name=N'Start_Post_Validation_Job', 
		@step_id=@step_no, 
		@cmdexec_success_code=0, 
		@on_success_action=1, 
		@on_success_step_id=0, 
		@on_fail_action=2, 
		@on_fail_step_id=0, 
		@retry_attempts=0, 
		@retry_interval=0, 
		@os_run_priority=0, 
		@subsystem=N'TSQL', 
		@command=@command, 
		@database_name=N'msdb', 
		@flags=0
IF (@@ERROR <> 0 OR @ReturnCode <> 0) GOTO QuitWithRollback

select @lastJobstepId = MAX([step_id])
from [msdb].[dbo].[sysjobsteps] 
where [job_id] = @ValidationId

IF (@@ERROR <> 0 OR @ReturnCode <> 0) GOTO QuitWithRollback
EXEC @ReturnCode = msdb.dbo.sp_update_jobstep @job_id = @ValidationId,@step_id = @lastJobstepId, @on_success_action = 1, @on_fail_action = 1

IF (@@ERROR <> 0 OR @ReturnCode <> 0) GOTO QuitWithRollback
EXEC @ReturnCode = msdb.dbo.sp_update_job @job_id = @ValidationId, @start_step_id = 1

EXEC @ReturnCode = msdb.dbo.sp_add_jobserver @job_id = @ValidationId, @server_name = N'(local)'
IF (@@ERROR <> 0 OR @ReturnCode <> 0) GOTO QuitWithRollback

-- Delete Old post process Job if exists
BEGIN  
	DECLARE @oldPostProcessValidationId  Uniqueidentifier
			select @oldPostProcessValidationId = [job_id]
from [msdb].[dbo].[sysjobs] 
where [name] = @PostProcessJobName

	IF (@oldPostProcessValidationId IS NOT NULL)
	BEGIN
		print 'Deleting post process job ' + @PostProcessJobName
		EXEC msdb.dbo.sp_delete_job @job_id=@oldPostProcessValidationId, @delete_unused_schedule=1
	END
END

-- Create post process job 
EXEC @ReturnCode =  msdb.dbo.sp_add_job @job_name=@PostProcessJobName, 
		@enabled=1, 
		@notify_level_eventlog=0, 
		@notify_level_email=0, 
		@notify_level_netsend=0, 
		@notify_level_page=0, 
		@delete_level=0, 
		@description=N'Watchdog ssis post validation job update the status of Watchdog_Plugins_Ssis_Validation_SSIS and recreates steps of Watchdog_Plugins_Ssis_Validation_SSIS if there is any new proxy added on server', 
		@category_name=N'Data Collector', 
		@owner_login_name=N'sa', @job_id = @PostProcessValidationId OUTPUT
IF (@@ERROR <> 0 OR @ReturnCode <> 0) GOTO QuitWithRollback

-- Create Step to call validator with finish command line
SET @step_name = 'PostProcess_SSIS_Under_' + 'SqlAgent'
EXEC @ReturnCode = msdb.dbo.sp_add_jobstep @job_id=@PostProcessValidationId, @step_name=@step_name, 
		@step_id=1, 
		@cmdexec_success_code=0, 
		@on_success_action=3, 
		@on_success_step_id=0, 
		@on_fail_action=3, 
		@on_fail_step_id=0, 
		@retry_attempts=0, 
		@retry_interval=0, 
		@os_run_priority=0, @subsystem=N'SSIS', 
		@command=@jobStepFinishCommand, 
		@database_name=N'master', 
		@flags=0

IF (@@ERROR <> 0 OR @ReturnCode <> 0) GOTO QuitWithRollback

select @lastJobstepId = MAX([step_id])
from [msdb].[dbo].[sysjobsteps] 
where [job_id] = @PostProcessValidationId

IF (@@ERROR <> 0 OR @ReturnCode <> 0) GOTO QuitWithRollback
EXEC @ReturnCode = msdb.dbo.sp_update_jobstep @job_id = @PostProcessValidationId,@step_id = @lastJobstepId, @on_success_action = 1, @on_fail_action = 1

IF (@@ERROR <> 0 OR @ReturnCode <> 0) GOTO QuitWithRollback
EXEC @ReturnCode = msdb.dbo.sp_update_job @job_id = @PostProcessValidationId, @start_step_id = 1

EXEC @ReturnCode = msdb.dbo.sp_add_jobserver @job_id = @PostProcessValidationId, @server_name = N'(local)'
IF (@@ERROR <> 0 OR @ReturnCode <> 0) GOTO QuitWithRollback

COMMIT TRANSACTION
GOTO EndSave

QuitWithRollback:
  IF (@@TRANCOUNT > 0) ROLLBACK TRANSACTION
EndSave: